/*******************************************************************************
* Device      : AD18F08
* Author      :
* Version     : V0.0.1
* Date        : 20230508
* Description : 正端选择PA0，负端选择PB2,通过PA5输出比较结果，输出结果去反；通过PB5翻转检测是否有CMP高优先级中断产生,PB4读取CMPOUT的结果；
* Note        :
********************************************************************************/
#include "AD18F08.h"
#include "Periph.h"

/*********************************************************************************************
*
* _FINTOSC_DIV1   :  内部RC振荡器频率选择
* _DBG_OFF        :  DEBUG模式使能位
* _LVREN_OFF       :  禁止LVR
* _LVR24V         :  LVR的电压选择为2.4V
* _FLASH_CP1_OFF  :  1K~2K*16 FLASH CP保护
* _FLASH_CP0_OFF  :  0~1K*16 FLASH CP保护
* _IDIS_OFF		  :  模拟IO打开，数据读取控制位
* _CKSUM_OFF      :  校验使能位
* _CBP_OFF		  :  代码保护选择位
* _RESETE_OFF     :  外部复位使能
* _RSEL			  :  端口上下拉电阻选择
* _STV_ON		  :  堆栈溢出复位
* _PSUT_2		  :  上电复位时间选择
* _FCPU_4T        :  指令周期选择4T
* _WDTE_OFF       :  看门狗使能
* _TWDT_000       :  看门狗溢出时间选择
* _OSCM_HIRC_16M  :  系统时钟选择高速时钟
* _MTPDIS_OFF     :  SWD模式下读FALSH控制
* _ADCSP_ON		  :	 ADC采集速度选择
*
*    注意：1.配置字若无特别需求请勿修改；
*       2.其他配置字及相应功能见Datasheet及头文件；
************************************************************************************************/

__CONFIG(1,_FINTOSC_DIV1_1L     & _DBG_OFF_1L       & _LVREN_OFF_1L     & _LVR24V_1L                                                  );
__CONFIG(2,_FLASH_CP1_OFF_2L    & _FLASH_CP0_OFF_2L & _IDIS_OFF_2L     & _CKSUM_OFF_2L  & _CBP_OFF_2L   & _RESETE_OFF_2L & _RSEL_HIGH_2L & _STV_ON_2L  );
__CONFIG(3,_PSUT_2_3L           & _FCPU_4T_3L       & _WDTE_OFF_3L    & _TWDT_100_3L                                                );
__CONFIG(4,_OSCM_HIRC_16M_4L    & _MTPDIS_OFF_4L    &_ADCSP_ON_4L                                                                                     );



void main(void)
{
	GPIO_INIT();// GPIO 的初始化

	PA0PD=1;PA0PU=1;TRISA0=1;PA0AEN=1;	//正端选择PA0，PA0的配置：上下拉关闭，设置PA0为输入，PA0的模拟通道打开
	PB2PD=1;PB2PU=1;TRISB2=1;PB2AEN=1;	//负端选择PB2，PB2的配置：上下拉关闭，设置PB2为输入，PB2的模拟通道打开


	// PA5PD=1;PA5PU=1;TRISA5=1;PA5AEN=1;	//PA5的配置：上下拉关闭，设置PA5为输入，PA5的模拟通道打开
	// PA3PD=1;PA3PU=1;TRISA3=1;PA3AEN=1;	//PA3的配置：上下拉关闭，设置PA3为输入，PA3的模拟通道打开

	// PB6PD=1;PB6PU=1;TRISB6=1;PB6AEN=1;	//PB6的配置：上下拉关闭，设置PB6为输入，PB6的模拟通道打开
	// PB7PD=1;PB7U=1;TRISB7=1;PB7AEN=1;	//PB6的配置：上下拉关闭，设置PB7为输入，PB7的模拟通道打开



//---------------------------通道的选择以及输出IO-----------------------------
	//Pch:0-PB6,1-PA3,2-PB4,3-PA0,4-DAC,5-ADC_MUX,6-FVR,7-GND
	//Nch:0-PB7,1-PA5,2-PA2,3-PB2,4-DAC,5-ADC_MUX,6-FVR,7-PA1

	//Mode<7>:  0-不输出到IO(PB6),1-输出到IO(PB6)
	//Mode<6>:  0-不输出到IO(PB1),1-输出到IO(PB1)
	//Mode<5>:  0-不输出到IO(PA5),1-输出到IO(PA5)
	//Mode<4>:  0-不输出到IO(PA1),1-输出到IO(PA1)
	//Mode<0>:  0-禁止,1-使能


	Cmp_Cfg(3, 3, 0X21);	//Pch_PA0,Nch_PB2, PA5输出比较结果
	//Cmp_Cfg(1,1,0X41);	//Pch_PA3,Nch_PA5, PB1输出比较结果， 使用该配置时需要将PB1设置为输出模式；
	//Cmp_Cfg(0,0,0X11);	//Pch_PB6,Nch_PB7, PA1输出比较结果， 使用该配置时需要将PA1设置为输出模式;
	//Cmp_Cfg(1,1,0X81);	//Pch_PA3,Nch_PA5, PB6输出比较结果， 使用该配置时需要将PB6设置为输出模式;
	//Cmp_Cfg(0,0,0X11);	//Pch_PB6,Nch_PB7, PA1输出比较结果， 使用该配置时需要将PA1设置为输出模式;

	CMPIF=0;    //初始化CMP的中断标志位；
	CMPIE=1;    //CMP的中断允许使能位，使能之后才可以进中断服务函数
	CMPIP=1;	//CMP高优先级使能

	IPEN=1;		//高低优先级中断使能位
	GIEH=1;		//使能高优先级总中断
	GIEL=1;     //使能低优先级总中断

    TRISA5=0;//PA5设置为输出，输出比较结果
	TRISB4=0;//PB4设置为输出，用于读取CMPOUT
	TRISB5=0;//PB5设置为输出，用于检测中断是否产生

	while(1)
	{
		PB4=CMPOUT;	//PB4读取比较结果
	}

}



//高优先级中断服务函数

void interrupt ISR_h (void)
{
//进入中断后系统自动关闭中断

	if((CMPIE==1)&&(CMPIF==1))
	{
	   	CMPIF=0;
	    PB5=~PB5;
	}
}

//低优先级中断服务函数

void interrupt low_priority ISR_l (void)
{


}
